define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/preferred-date/date-collapsible',
    'modules/new-appointment-request/views/direct/preferred-date/time-button',
], function(Backbone, Layout, DateCollapsibleView, TimeButtonView) {
    'use strict';

    describe('Date Collapsible View', function() {
        var view;
        var $view;
        var model = new Backbone.Model({
            date: '06/12/2016',
            timeSlots: new Backbone.Collection([
                {startDateTime: '06/12/2016 14:30:00'},
                {startDateTime: '06/12/2016 15:00:00'},
                {startDateTime: '06/12/2016 15:30:00'},
            ]),
        });
        var layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(DateCollapsibleView.prototype, 'updateTimeSlots').and.callThrough();
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        describe('when initialized', function () {
            beforeEach(function() {
                view = new DateCollapsibleView({model: model});
            });

            it('has TimeButtonView as its childView', function () {
                expect(view.childView).toBe(TimeButtonView);
            });
        });

        describe('when initialized with option.collapsed as false', function () {
            beforeEach(function() {
                view = new DateCollapsibleView({
                    collapsed: false,
                    model: model,
                });
                layout.showChildView('content', view);
                view.$el.trigger('create');
                $view = view.$el;
            });

            it('is rendered as an expanded collapsible', function () {
                expect($view.hasClass('ui-collapsible-collapsed')).toBe(false);
            });

            it('has a date heading and pre-rendered jQuery Mobile 1.4.5 collapsible header', function () {
                expect($view.find('.ui-collapsible-heading span[aria-hidden="true"]').text()).toEqual('06/12/2016');
                expect($view.find('.ui-collapsible-heading').hasClass('ui-collapsible-heading-collapsed')).toBe(false);
                expect($view.find('.ui-collapsible-heading-status').text()).toEqual('June 12 2016 select to collapse content');
            });

            it('has pre-rendered, styled jQuery Mobile 1.4.5 collapsible content', function () {
                expect($view.find(view.childViewContainer).hasClass('available-time-slots')).toBe(true);
                expect($view.find(view.childViewContainer).attr('aria-hidden')).toEqual('false');
                expect($view.find(view.childViewContainer).hasClass('ui-collapsible-content-collapsed')).toBe(false);
            });

            it('shows the timeslots', function () {
                expect(view.updateTimeSlots).toHaveBeenCalled();
                expect($view.find(view.childViewContainer).children().length).toEqual(3);
            });
        });

        describe('when initialized with option.collapsed as true', function () {
            beforeEach(function() {
                view = new DateCollapsibleView({model: model});

                layout.showChildView('content', view);
                view.$el.trigger('create');
                $view = view.$el;
            });

            it('is rendered as a collapsed collapsible', function () {
                expect($view.hasClass('ui-collapsible-collapsed')).toBe(true);
            });

            it('has a date heading and pre-rendered jQuery Mobile 1.4.5 collapsible header', function () {
                expect($view.find('.ui-collapsible-heading span[aria-hidden="true"]').text()).toEqual('06/12/2016');
                expect($view.find('.ui-collapsible-heading').hasClass('ui-collapsible-heading-collapsed')).toBe(true);
                expect($view.find('.ui-collapsible-heading-status').text()).toEqual('June 12 2016 select to expand content');
            });

            it('has pre-rendered, styled jQuery Mobile 1.4.5 collapsible content', function () {
                expect($view.find(view.childViewContainer).hasClass('available-time-slots')).toBe(true);
                expect($view.find(view.childViewContainer).attr('aria-hidden')).toEqual('true');
                expect($view.find(view.childViewContainer).hasClass('ui-collapsible-content-collapsed')).toBe(true);
            });

            xit('shows the time slots after being expanded', function () {
                expect(view.updateTimeSlots).not.toHaveBeenCalled();
                $view.collapsible('expand');
                expect(view.updateTimeSlots).toHaveBeenCalled();
                expect($view.find(view.childViewContainer).children().length).toEqual(3);
            });
        });

    });

}
);
